#include "General.h"
#include "ChatAliases.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "HashTemplateClass.h"
#include "HashTemplateIterator.h"
#include "gmgame.h"

HashTemplateClass<StringClass, WideStringClass> AliasesTable;

ChatAliases::ChatAliases()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_CHAT_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

ChatAliases::~ChatAliases()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_CHAT_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void ChatAliases::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	int Count = SSGMIni->Entry_Count("ChatAliases_AliasesList");
	for (int i = 0; i < Count; i++)
	{
		const char *Entry = SSGMIni->Get_Entry("ChatAliases_AliasesList", i);
		StringClass Insert;
		SSGMIni->Get_String(Insert, "ChatAliases_AliasesList", Entry);

//		Console_Output("key = %s, value = %s\n", Entry, Insert); // DEBUG CRAP
		AliasesTable.Insert(Entry, WideStringClass(Insert));
	}
}

bool ChatAliases::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{	
	if ( AliasesTable.Exists(Message) )
	{
		WideStringClass TextFromAlias = AliasesTable.Get(Message, L"ERR");

		if (TextFromAlias == L"ERR") { return true; }

		Send_Client_Text(TextFromAlias, Type, false, PlayerID, -1, true, true);
		return false;
	}
	return true;
}


ChatAliases chatAliases;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &chatAliases;
}
